-- # Requêtes SQL pour Contestify

-- = ========== =
-- = Actualités =
-- = ========== =

-- - Sprint 1

-- V_ 1. Requête listant toutes les actualités de la table des actualités et leur auteur (login).
SELECT act_titre, cpt_pseudo FROM t_actualite_act;


-- V_ 2. Requête donnant les données d'une actualité dont on connaît l'identifiant (n°).
SELECT * FROM t_actualite_act WHERE act_idActualite = <id>;


-- V_ 3. Requête listant les 5 dernières actualités dans l'ordre décroissant.
SELECT * FROM t_actualite_act ORDER BY act_idActualite DESC LIMIT 5;


-- V_ 4. Requête recherchant et donnant la (ou les) actualité(s) contenant un mot particulier.
SELECT * FROM t_actualite_act WHERE act_message LIKE "%un mot particulier%";


-- V_ 5. Requête listant toutes les actualités postées à une date particulière + le login de l’auteur.
SELECT * FROM t_actualite_act WHERE act_date = '2023-02-16';





-- = ======== =
-- = Concours =
-- = ======== =
@0Yugo0Adamaï0@
-- - Sprint 1

-- V_ 1. Requête listant tous les concours de la plateforme (passés, en cours, à venir).
SELECT conc_nomConcours FROM t_concours_conc;


-- PE_ 2. Requête(s) listant tous les concours de la plateforme (passés, en cours, à venir) avec leurs principales caractéristiques (organisateur responsable, date de début, date de fin, catégories, nom, prénom et discipline des juges).

SELECT conc_nomConcours, conc_description, conc_date_debut, conc_date_debut_selection, conc_date_debut_finale, conc_date_fin, cpt_pseudo, donnerCategoriesConcours(`conc_idConcours`) AS 'categories', donnerJuryConcours(`conc_idConcours`) AS 'jury'

FROM t_concours_conc;



SELECT conc_nomConcours, conc_description, conc_date_debut, conc_date_debut_selection, conc_date_debut_finale, conc_date_fin, cpt_pseudo, GROUP_CONCAT(donnerCategoriesConcours(`conc_idConcours`)) AS 'categories', GROUP_CONCAT(donnerJuryConcours(`conc_idConcours`)) AS 'jury'

FROM t_concours_conc;


-- V_ 3. Requête listant les concours qui ont débuté et leur phase actuelle (ex : finale).
SELECT conc_nomConcours, conc_phase FROM t_concours_conc WHERE CURRENT_DATE() > conc_date_debut AND CURRENT_DATE() < conc_date_fin AND conc_phase != 'T';


-- V_ 4. Requête listant les concours à venir avec leur date de début.
SELECT conc_nomConcours, conc_date_debut FROM t_concours_conc WHERE CURRENT_DATE() < conc_date_debut AND conc_phase = 'V';


-- PE_ 5. Requête donnant toutes les caractéristiques d’un concours particulier (ID connu).
-- SELECT ;


-- V_ 6. Requête donnant les informations des membres du jury d’un concours particulier (ID connu).
SELECT cpt_pseudo, jury_discipline, jury_url, jury_bio
FROM t_compte_jury JOIN t_siege_siege USING(cpt_pseudo)
WHERE conc_idConcours = <id>;


-- V_ 7. Requête listant tous les membres de jury, classés par discipline, pour tous les concours de la plateforme.
SELECT cpt_pseudo, jury_discipline
FROM t_compte_jury
ORDER BY jury_discipline;


-- V_ 8. Requête donnant la liste des catégories d’un concours particulier (ID connu).
SELECT cat_nomCategorie FROM t_categorie_cat JOIN t_possede_poss USING(cat_idCategorie) WHERE conc_idConcours = 4;


-- A_ 9. Requête listant de tous les administrateurs de la plateforme et les concours dont il est (/a été) responsable, s’il y en a.







-- = =========== =
-- = Inscription =
-- = =========== =

-- - Sprint 1 (en tant que candidat)

-- V_ 1. Requête vérifiant l’existence du couple de codes (identification / inscription).
SELECT COUNT(*) AS 'nbCouples' FROM t_participant_part WHERE part_codeInscription = '<codeInscription>' AND part_codeIdentifiant = '<codeIdentifiant>';


-- A_ 2. Requête d’affichage, si autorisé, de toutes les informations associées à une inscription connaissant le couple de code d’identification / code d’inscription.






-- = ====================== =
-- = Profils (admin / jury) =
-- = ====================== =

-- - Sprint 1 (en tant qu'administrateur / membre du jury)

-- V_ 1. Requête listant toutes les données de tous les profils classés par statut.
SELECT cpt_pseudo, cpt_mdp, cpt_nom, cpt_prenom, cpt_etat, jury_discipline, jury_url, jury_bio FROM t_compte_cpt JOIN t_compte_jury WHERE cpt_pseudo = '<pseudo>' ORDER BY cpt_etat;


-- V_ 2. Requête de vérification des données de connexion (login et mot de passe).
SELECT COUNT(*) AS 'nbCouples' FROM t_compte_cpt WHERE cpt_pseudo = '<pseudo>' AND cpt_mdp = '<motDePasse>';


-- V_ 3. Requête récupérant les données d'un profil particulier (utilisateur connecté)
SELECT cpt_pseudo, cpt_mdp, cpt_nom, cpt_prenom, cpt_etat, jury_discipline, jury_url, jury_bio FROM t_compte_cpt JOIN t_compte_jury WHERE cpt_pseudo = '<pseudo>';


-- V_ 4. Requête de mise à jour du mot de passe d'un profil.
UPDATE t_compte_cpt SET cpt_mdp = SHA2(CONCAT("sel", "<nouveauMotDePasse>"), 256) WHERE cpt_pseudo = "<pseudo>";


-- A_ 5. Requête d'ajout des données d'un profil administrateur (/ membre du jury).
